package com.ejie.ab04b.service;

import java.util.List;

import com.ejie.ab04b.model.OS3;
import com.ejie.ab04b.model.TramiteOS3;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0495s00Service generated by UDA, 05-Apr-2017 09:34:34.
 * 
 * @author UDA
 */

public interface TramiteOS3Service {

	/**
	 * Inserts a single row in the Ab0495s00 table.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  Ab0495s00
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @return the tramite OS 3
	 */
	TramiteOS3 add(TramiteOS3 ab0495s00);

	/**
	 * Updates a single row in the Ab0495s00 table.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  Ab0495s00
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @return the tramite OS 3
	 */
	TramiteOS3 update(TramiteOS3 ab0495s00);

	/**
	 * Finds a single row in the Ab0495s00 table.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  Ab0495s00
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @return the tramite OS 3
	 */
	TramiteOS3 find(TramiteOS3 ab0495s00);

	/**
	 * Finds a single row in the TramiteAperturas table.
	 * 
	 *  idTipoTramite
	 *            Long
	 *  os3
	 *            OS3
	 *  TramiteOS3
	 *
	 * @param idTipoTramite the id tipo tramite
	 * @param os3 the os 3
	 * @return the tramite OS 3
	 */
	public TramiteOS3 findLastTramiteByTipo(Long idTipoTramite, OS3 os3);

	/**
	 * Busca un trámite y le carga su lista de tareas asociadas.
	 * 
	 *  tramiteOS3            TramiteOS3
	 *  TramiteOS3
	 *
	 * @param tramiteOS3 the tramite OS 3
	 * @return the tramite OS 3
	 */
	public TramiteOS3 findConTareas(TramiteOS3 tramiteOS3);

	/**
	 * Deletes a single row in the Ab0495s00 table.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 */
	void remove(TramiteOS3 ab0495s00);

	/**
	 * Finds a list of rows in the Ab0495s00 table.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0495s00>
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<TramiteOS3> findAll(TramiteOS3 ab0495s00,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Ab0495s00 table using like.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0495s00>
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TramiteOS3> findAllLike(TramiteOS3 ab0495s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0495s00 table.
	 * 
	 *  filterAb0495s00
	 *            Ab0495s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0495s00>
	 *
	 * @param filterAb0495s00 the filter ab 0495 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<TramiteOS3> filter(TramiteOS3 filterAb0495s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Ab0495s00 table.
	 * 
	 *  filterAb0495s00
	 *            Ab0495s00
	 *  searchAb0495s00
	 *            Ab0495s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0495s00>>
	 *
	 * @param filterAb0495s00 the filter ab 0495 s 00
	 * @param searchAb0495s00 the search ab 0495 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<TramiteOS3>> search(TramiteOS3 filterAb0495s00,
			TramiteOS3 searchAb0495s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in Ab0495s00 table.
	 * 
	 *  filterAb0495s00
	 *            Ab0495s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0495s00 the filter ab 0495 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	Object reorderSelection(TramiteOS3 filterAb0495s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

}
